/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.util;

import java.util.Vector;

public class Species {
    private String m_cas = null;
    private Vector m_formulaList;
    private Vector m_nameList;

    public Species() {
        this.m_formulaList = new Vector();
        this.m_nameList = new Vector();
    }

    public Species(String cas) {
        this.m_cas = cas == null ? "" : cas;
        this.m_formulaList = new Vector();
        this.m_nameList = new Vector();
    }

    public String getCas() {
        return this.m_cas;
    }

    public Vector getFormulaList() {
        return this.m_formulaList;
    }

    public Vector getNameList() {
        return this.m_nameList;
    }

    public void setCas(String cas) {
        this.m_cas = cas == null ? new String("") : new String(cas);
    }

    public void addFormulaToList(String formula, String type) {
        Tuple tup = new Tuple(formula, type);
        this.m_formulaList.addElement(tup);
    }

    public Tuple removeFirstFormulaInList() {
        if (this.m_formulaList.isEmpty()) {
            return null;
        }
        Tuple tup = (Tuple)this.m_formulaList.remove(0);
        return tup;
    }

    public void addNameToList(String name, String type) {
        Tuple tup = new Tuple(name, type);
        this.m_nameList.addElement(tup);
    }

    public Tuple removeFirstNameInList() {
        if (this.m_nameList.isEmpty()) {
            return null;
        }
        Tuple tup = (Tuple)this.m_nameList.remove(0);
        return tup;
    }

    public static class Tuple {
        private String m_value = null;
        private String m_type = null;

        public Tuple(String value, String type) {
            this.m_value = value;
            this.m_type = type;
        }

        public String getValue() {
            return this.m_value;
        }

        public String getType() {
            return this.m_type;
        }
    }
}

